package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.autoconfigure.properties.RamProperties;
import com.digiwin.dap.middle.ram.constant.RamConstant;
import com.digiwin.dap.middle.ram.filter.AfterAuthenticationFilter;
import com.digiwin.dap.middle.ram.filter.AuthCheckFilter;
import com.digiwin.dap.middle.ram.filter.BeforeAuthenticationFilter;
import com.digiwin.dap.middle.ram.service.access.policy.AllowListPolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.access.policy.BasePolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.access.policy.BeforePolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.access.policy.NonePolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.access.policy.PolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandler;
import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandlerComposite;
import com.digiwin.dap.middle.ram.service.authentication.AuthCheckService;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

import javax.servlet.Filter;
import java.util.ArrayList;
import java.util.List;

/**
 * 核心服务
 * 拦截器：普通策略
 * 拦截器：授权检查
 * 过滤器：服务权限
 *
 * @author fobgochod
 * @date 2022/5/18 11:19
 */
@Configuration
@EnableConfigurationProperties(RamProperties.class)
public class RamCoreConfiguration {

    private final RamProperties properties;

    public RamCoreConfiguration(RamProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnBean(value = RamCoreService.class)
    @ConditionalOnMissingBean(name = "beforeAuthenticationFilter")
    public FilterRegistrationBean<Filter> beforeAuthenticationFilter(RamCoreService ramCoreService) {
        List<PolicyFilterHandler> policyHandlers = new ArrayList<>();
        policyHandlers.add(new BeforePolicyFilterHandler());
        policyHandlers.add(new NonePolicyFilterHandler(ramCoreService));
        AnnotationAwareOrderComparator.sort(policyHandlers);

        FilterRegistrationBean<Filter> registrationBean = new FilterRegistrationBean<>();
        BeforeAuthenticationFilter beforeAuthenticationFilter = new BeforeAuthenticationFilter(policyHandlers);
        registrationBean.setFilter(beforeAuthenticationFilter);
        registrationBean.setOrder(beforeAuthenticationFilter.getOrder());
        registrationBean.addUrlPatterns(RamConstant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    @ConditionalOnBean(value = RamCoreService.class)
    @ConditionalOnMissingBean(name = "afterAuthenticationFilter")
    public FilterRegistrationBean<Filter> afterAuthenticationFilter(RamCoreService ramCoreService) {
        List<PolicyFilterHandler> policyHandlers = new ArrayList<>();
        policyHandlers.add(new AllowListPolicyFilterHandler(ramCoreService));
        policyHandlers.add(new BasePolicyFilterHandler(ramCoreService));
        AnnotationAwareOrderComparator.sort(policyHandlers);

        FilterRegistrationBean<Filter> registrationBean = new FilterRegistrationBean<>();
        AfterAuthenticationFilter afterAuthenticationFilter = new AfterAuthenticationFilter(policyHandlers);
        registrationBean.setFilter(afterAuthenticationFilter);
        registrationBean.setOrder(afterAuthenticationFilter.getOrder());
        registrationBean.addUrlPatterns(RamConstant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }

    @Bean
    @ConditionalOnBean(value = {AuthCheckService.class, RamCoreService.class})
    public AuthCheckHandlerComposite appCheckHandler(AuthCheckService authCheckService, RamCoreService ramCoreService) {
        return new AuthCheckHandlerComposite(authCheckService, ramCoreService);
    }

    @Bean
    @ConditionalOnBean(value = AuthCheckHandlerComposite.class)
    @ConditionalOnMissingBean(name = "authCheckFilter")
    public FilterRegistrationBean<Filter> authCheckFilter(AuthCheckHandler authCheckHandler) {
        FilterRegistrationBean<Filter> registrationBean = new FilterRegistrationBean<>();
        AuthCheckFilter authCheckFilter = new AuthCheckFilter(authCheckHandler);
        registrationBean.setFilter(authCheckFilter);
        registrationBean.setOrder(authCheckFilter.getOrder());
        registrationBean.addUrlPatterns(RamConstant.DEFAULT_URL_MAPPINGS);
        registrationBean.setAsyncSupported(true);
        return registrationBean;
    }
}
