package com.digiwin.dap.middle.autoconfigure.condition;

import com.digiwin.dap.middle.ram.filter.RamV1AccessCheckFilter;
import com.digiwin.dap.middleware.auth.domain.RamVersion;
import com.digiwin.dap.middleware.auth.filter.RamV2AccessCheckFilter;
import com.digiwin.dap.middleware.domain.CommonCode;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * dapware-ram 只被iam和ram引入
 * <p>
 * v1:鉴权以jar模式在IAM启用时，iam启动该jar包，ram提供鉴权拦截器{@link RamV1AccessCheckFilter}
 * v2:鉴权独立服务在RAM启用时，ram启用该jar包，由core提供拦截器{@link RamV2AccessCheckFilter}
 */
public class RamOrIamV1Condition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String appName = context.getEnvironment().getProperty("spring.application.name");
        String version = context.getEnvironment().getProperty("dap.middleware.ram.version");

        return CommonCode.RAM.name().equalsIgnoreCase(appName)
                || (CommonCode.IAM.name().equalsIgnoreCase(appName) && RamVersion.v1.name().equalsIgnoreCase(version));
    }
}