/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.ram.support.cache.CachePurgeMessageListener;
import com.digiwin.dap.middle.ram.support.cache.CachePurgePublisherService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@Configuration
@ConditionalOnProperty(prefix="dap.middleware.ram", value={"cache"}, havingValue="true")
public class RamPubSubConfiguration {
    @Bean
    public CachePurgePublisherService cachePurgePublisherService() {
        return new CachePurgePublisherService();
    }

    @Bean
    public CachePurgeMessageListener cachePurgeMessageListener() {
        return new CachePurgeMessageListener();
    }

    @Bean
    public MessageListenerAdapter listenerAdapter(CachePurgeMessageListener listener) {
        return new MessageListenerAdapter((Object)listener);
    }

    @Bean
    public RedisMessageListenerContainer listenerContainer(RedisConnectionFactory factory, MessageListenerAdapter adapter) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(factory);
        container.addMessageListener((MessageListener)adapter, (Topic)new PatternTopic("ram:cache:purge"));
        return container;
    }
}

