package com.digiwin.dap.middle.autoconfigure.config;

import com.digiwin.dap.middle.ram.constant.RamConstant;
import com.digiwin.dap.middle.ram.support.cache.CachePurgeMessageListener;
import com.digiwin.dap.middle.ram.support.cache.CachePurgePublisherService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@Configuration
@ConditionalOnProperty(prefix = "dap.middleware.ram", value = "cache", havingValue = "true")
public class RamPubSubConfiguration {

    @Bean
    public CachePurgePublisherService cachePurgePublisherService() {
        return new CachePurgePublisherService();
    }

    @Bean
    public CachePurgeMessageListener cachePurgeMessageListener() {
        return new CachePurgeMessageListener();
    }

    @Bean
    public MessageListenerAdapter listenerAdapter(CachePurgeMessageListener listener) {
        return new MessageListenerAdapter(listener);
    }

    @Bean
    public RedisMessageListenerContainer listenerContainer(RedisConnectionFactory factory, MessageListenerAdapter adapter) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(factory);
        // 绑定到具体的频道，比如 cache:invalidate
        container.addMessageListener(adapter, new PatternTopic(RamConstant.CACHE_PURGE_TOPIC));
        return container;
    }
}
