/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.autoconfigure;

import com.digiwin.dap.middle.autoconfigure.RamConfigurations;
import com.digiwin.dap.middle.autoconfigure.condition.RamOrIamV1Condition;
import com.digiwin.dap.middle.autoconfigure.properties.RamType;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

@AutoConfiguration
@ConditionalOnWebApplication
@Conditional(value={RamOrIamV1Condition.class})
@Import(value={RamConfigurationImportSelector.class})
public class RamAutoConfiguration {

    static class RamConfigurationImportSelector
    implements ImportSelector {
        RamConfigurationImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata importingClassMetadata) {
            RamType[] types = RamType.values();
            String[] imports = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                imports[i] = RamConfigurations.getConfigurationClass(types[i]);
            }
            return imports;
        }
    }
}

