package com.digiwin.dap.middle.autoconfigure.condition;

import com.digiwin.dap.middle.ram.filter.RamV1AccessCheckFilter;
import com.digiwin.dap.middleware.auth.domain.RamVersion;
import com.digiwin.dap.middleware.domain.CommonCode;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * 鉴权以jar模式在IAM启用时，才使用该拦截器
 *
 * @see RamV1AccessCheckFilter
 */
public class IamV1Condition implements Condition {

    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String appName = context.getEnvironment().getProperty("spring.application.name");
        String version = context.getEnvironment().getProperty("dap.middleware.ram.version");

        return CommonCode.IAM.name().equalsIgnoreCase(appName) && RamVersion.v1.name().equalsIgnoreCase(version);
    }
}