package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.util.JdbcUtils;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 初始化数据
 *
 * @author fobgo
 * @date 2021/10/8 10:09
 */
@RequestMapping("/api/ram/v2/data")
@RestController
public class DataApi {

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @GetMapping("/init")
    public StdData<?> init() {
        JdbcUtils.initTemp(jdbcTemplate);
        return StdData.ok();
    }

    @PostMapping("/init")
    public StdData<?> init(@RequestBody String body) {
        JdbcUtils.exec(jdbcTemplate, body);
        return StdData.ok();
    }
}
