package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.service.base.RamGrantPolicyCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * GrantController.java
 *
 * @author Xiao
 * @date 2021/8/19 9:31
 */
@RequestMapping("/api/ram/v2/grant")
@RestController
public class GrantApi {

    @Autowired
    private RamGrantCrudService ramGrantCrudService;
    @Autowired
    private RamGrantPolicyCrudService ramGrantPolicyCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody Grant body) {
        long sid = ramGrantCrudService.insert(body);
        return StdData.ofSuccess(BaseSid.ok(sid));
    }

    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        int count = ramGrantCrudService.deleteBySid(body.getSid());
        return StdData.ofSuccess(BaseSid.ok(count));
    }

    @PostMapping("/mod")
    public StdData<?> mod(@RequestBody Grant body) {
        Grant grant = ramGrantCrudService.findBySid(body.getSid());
        if (grant != null) {
            grant.setType(body.getType());
            grant.setTargetId(body.getTargetId());
            ramGrantCrudService.update(grant);
            return StdData.ofSuccess(BaseSid.ok(grant.getSid()));
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/get")
    public StdData<?> get(@RequestBody BaseSid body) {
        Grant grant = ramGrantCrudService.findBySid(body.getSid());
        if (grant != null) {
            return StdData.ofSuccess(grant);
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/find")
    public StdData<?> find(@RequestBody GrantVO body) {
        return StdData.ofSuccess(ramGrantCrudService.findByPage(body));
    }

    @PostMapping("/get/policy")
    public StdData<?> getPolicy(@RequestBody BaseSid body) {
        Grant grant = ramGrantCrudService.findBySid(body.getSid());
        if (grant == null) {
            throw new RuntimeException("策略不存在");
        }
        List<PolicyVO> policies = ramGrantPolicyCrudService.findByGrantSid(grant.getSid());
        return StdData.ofSuccess(new GrantVO(grant, policies));
    }

    @PostMapping("/find/policy")
    public StdData<?> findPath(@RequestBody GrantVO body) {
        return StdData.ofSuccess(ramGrantCrudService.findByPageCount(body));
    }
}
