package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.RouteVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.entity.BaseSid;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * PolicyController.java
 *
 * @author Xiao
 * @date 2021/8/19 9:31
 */
@RequestMapping("/api/ram/v2/policy")
@RestController
public class PolicyApi {

    @Autowired
    private RamPolicyCrudService ramPolicyCrudService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody Policy body) {
        long sid = ramPolicyCrudService.insert(body);
        return StdData.ofSuccess(BaseSid.ok(sid));
    }

    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        int count = ramPolicyCrudService.deleteBySid(body.getSid());
        return StdData.ofSuccess(BaseSid.ok(count));
    }

    @PostMapping("/mod")
    public StdData<?> mod(@RequestBody Policy body) {
        Policy path = ramPolicyCrudService.findBySid(body.getSid());
        if (path != null) {
            path.setType(body.getType());
            path.setId(body.getId());
            path.setName(body.getName());
            ramPolicyCrudService.update(path);
            return StdData.ofSuccess(BaseSid.ok(path.getSid()));
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/get")
    public StdData<?> get(@RequestBody BaseSid body) {
        Policy path = ramPolicyCrudService.findBySid(body.getSid());
        if (path != null) {
            return StdData.ofSuccess(path);
        }
        return StdData.ofSuccess(BaseSid.ok(0));
    }

    @PostMapping("/find")
    public StdData<?> find(@RequestBody PolicyVO body) {
        return StdData.ofSuccess(ramPolicyCrudService.findByPage(body));
    }

    @PostMapping("/get/path")
    public StdData<?> getPath(@RequestBody BaseSid body) {
        Policy policy = ramPolicyCrudService.findBySid(body.getSid());
        if (policy == null) {
            throw new RuntimeException("策略不存在");
        }
        List<RouteVO> paths = ramPolicyRouteCrudService.findByPolicySid(body.getSid());
        return StdData.ofSuccess(new PolicyVO(policy, paths));
    }

    @PostMapping("/find/path")
    public StdData<?> findPath(@RequestBody PolicyVO body) {
        return StdData.ofSuccess(ramPolicyCrudService.findByPageCount(body));
    }
}
