package com.digiwin.dap.middle.ram.constant;

/**
 * Cache缓存名
 *
 * @author Xiao
 * @date 2021/8/19 15:39
 */
public interface CacheConstant {

    String REDIS_TEMPLATE = "ramRedisTemplate";
    String CACHE_MANAGER = "ramRedisCacheManager";

    String CACHE_NAME_GRANT = "grant";
    String CACHE_NAME_POLICY = "policy";

    String POLICY_TYPE = "%s:ram:policy:%s";
    String POLICY_ID = "%s:ram:policy:%s:%s";
    String POLICY_PATH = "%s:ram:policy:%s:{%s %s}";
    String GRANT_TARGET = "%s:ram:grant:%s:%s:%s";

    static String getPolicyType(String prefix, String policyType) {
        return String.format(POLICY_TYPE, prefix, policyType);
    }

    static String getPolicyId(String prefix, String policyType, String policyId) {
        return String.format(POLICY_ID, prefix, policyType, policyId);
    }

    static String getPolicyPath(String prefix, String policyType, String method, String path) {
        return String.format(POLICY_PATH, prefix, policyType, method, path);
    }

    static String getGrantTarget(String prefix, String policyType, String targetType, String targetId) {
        return String.format(GRANT_TARGET, prefix, policyType, targetType, targetId);
    }
}
