package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.entity.Route;

import java.util.Objects;

/**
 * API缓存
 *
 * @author fobgo
 * @date 2021/9/26 17:09
 */
public class PatternVO {

    private String method;
    private String path;
    private Boolean effect;

    public PatternVO() {
    }

    public PatternVO(Route route) {
        this.method = route.getMethod();
        this.path = route.getPath();
    }

    public PatternVO(String method, String path) {
        this.method = method;
        this.path = path;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Boolean getEffect() {
        return effect;
    }

    public void setEffect(Boolean effect) {
        this.effect = effect;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PatternVO patternVO = (PatternVO) o;
        return Objects.equals(method, patternVO.method) && path.equals(patternVO.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(method, path);
    }

    @Override
    public String toString() {
        return '{' + ((method == null) ? "" : method + '-') + path + '}';
    }
}
