package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.function.Function;
import com.digiwin.dap.middleware.util.TokenUtils;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import static com.digiwin.dap.middle.ram.domain.enums.TargetType.Sys;
import static com.digiwin.dap.middle.ram.domain.enums.TargetType.Tenant;
import static com.digiwin.dap.middle.ram.domain.enums.TargetType.User;

/**
 * 目标类型
 *
 * @author Xiao
 * @date 2021/8/16 15:53
 */
public class TargetInfo {

    private final Map<TargetType, String> targets = new LinkedHashMap<>(3);
    private PatternVO pattern;
    private ResultType resultType = ResultType.IMPLICIT_DENY;
    private boolean obsolete;

    public void initTargets() {
        if (TokenUtils.getUserId() != null) {
            this.targets.put(User, TokenUtils.getUserId());
        }
        if (TokenUtils.getTenantId() != null) {
            this.targets.put(Tenant, TokenUtils.getTenantId());
        }
        if (TokenUtils.getSysId() != null) {
            this.targets.put(Sys, TokenUtils.getSysId());
        }
    }

    public PatternVO getPattern() {
        return pattern;
    }

    public void setPattern(PatternVO pattern) {
        this.pattern = pattern;
    }

    public ResultType getResultType() {
        return resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }

    public boolean isObsolete() {
        return obsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
    }

    public List<TargetType> targets() {
        return new ArrayList<>(targets.keySet());
    }

    public String obtain(TargetType targetType) {
        return targets.get(targetType);
    }

    public String functionKey() {
        return String.format(Function.REDIS_PERMISSION_KEY, targets.get(User), targets.get(Tenant), targets.get(Sys));
    }
}
