package com.digiwin.dap.middle.ram.domain.enums;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * 策略类型
 *
 * @author Xiao
 * @date 2021/8/16 15:37
 */
public enum PolicyType {

    /**
     * 不做权限管控，只有唯一一个策略
     */
    None,
    /**
     * 白名单
     */
    AllowList,
    /**
     * 黑名单（暂不处理）
     */
    BlockList,
    /**
     * 策略，系统策略(System)、自定义策略(Custom)
     */
    Base,
    /**
     * 功能权限策略
     */
    Function,
    /**
     * 废弃，只有唯一一个策略
     */
    Obsolete;

    private static final Set<PolicyType> DEFAULT_POLICIES;

    static {
        Set<PolicyType> defaultIncludes = new LinkedHashSet<>();
        defaultIncludes.add(PolicyType.None);
        defaultIncludes.add(PolicyType.AllowList);
        defaultIncludes.add(PolicyType.BlockList);
        defaultIncludes.add(PolicyType.Base);
        DEFAULT_POLICIES = Collections.unmodifiableSet(defaultIncludes);
    }

    /**
     * Return the default {@link PolicyType}.
     *
     * @return the default include.
     */
    public static Set<PolicyType> defaultPolicies() {
        return DEFAULT_POLICIES;
    }
}
