package com.digiwin.dap.middle.ram.domain.enums;

import com.digiwin.dap.middle.ram.util.I18nUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;

/**
 * 最小单元判定流程如下：
 * <ol>
 *   <li>权限判定遵循Deny优先原则，优先检查访问请求是否命中Deny语句。
 *     <ul>
 *       <li>是：判定结束，返回判定结果为Explicit Deny（显式拒绝）。</li>
 *       <li>否：继续下一步判定。</li>
 *     </ul>
 *   </li>
 *   <li>检查访问请求是否命中Allow语句。
 *     <ul>
 *       <li>是：判定结束，返回判定结果为Allow（允许）。</li>
 *       <li>否：判定结束，返回判定结果为Implicit Deny（隐式拒绝）。</li>
 *     </ul>
 *   </li>
 * </ol>
 *
 * @author fobgo
 * @date 2021/9/10 16:58
 */
public enum ResultType implements ErrorHandler {

    /**
     * 允许
     * <p>
     * 如果访问请求命中了权限策略中的Allow语句，且没有命中Deny语句，那么本次判定结果是Allow（允许）。
     */
    ALLOW("", ""),
    /**
     * 显式拒绝
     * <p>
     * 一旦访问请求命中了权限策略中的Deny语句，那么本次判定结果是Explicit Deny（显式拒绝）。
     * 即使此时访问请求同时命中了Allow语句，但遵循Deny优先原则，Deny语句优先级高于Allow语句，判定结果仍为显式拒绝。
     */
    EXPLICIT_DENY("20004", "dap.middleware.ram.access.explicit"),
    /**
     * 隐式拒绝
     * <p>
     * 如果访问请求既没有命中权限策略中的Allow语句，也没有命中Deny语句，那么本次判定结果是Implicit Deny（隐式拒绝）。
     * RAM身份默认没有执行任何操作的权限，没有被显式允许执行的操作都会被隐式拒绝。
     */
    IMPLICIT_DENY("20004", "dap.middleware.ram.access.implicit"),
    /**
     * 有效接口
     */
    OBSOLETE_ALLOW("", ""),
    /**
     * 废弃接口
     */
    OBSOLETE_DENY("20006", "dap.middleware.ram.access.obsolete");

    private final String errorCode;
    private final String code;

    ResultType(String errorCode, String code) {
        this.errorCode = errorCode;
        this.code = code;
    }

    @Override
    public String getErrorCode() {
        return errorCode;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getErrorMessage() {
        return I18nUtils.getAccessor().getMessage(code);
    }
}
