package com.digiwin.dap.middle.ram.entity;

import com.digiwin.dap.middle.ram.domain.RouteVO;
import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * 路由清单
 *
 * @author Xiao
 * @date 2021/8/16 15:57
 */
public class Route extends BaseEntity {

    private String app;
    private String method;
    private String path;
    private boolean type;

    public Route() {
    }

    public Route(RouteVO route) {
        this.method = route.getMethod();
        this.path = route.getPath();
    }

    public Route(String method, String path) {
        this.method = method;
        this.path = path;
    }

    public String getApp() {
        return app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isType() {
        return type;
    }

    public void setType(boolean type) {
        this.type = type;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (StringUtils.hasText(method)) {
            builder.append(method).append(" ");
        }
        builder.append(path);
        builder.append('}');
        return builder.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Route route = (Route) o;
        return Objects.equals(method, route.method) && path.equals(route.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(method, path);
    }
}
