package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.constant.Constant;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.TargetInfoContextHolder;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyTypeChain;
import com.digiwin.dap.middle.ram.service.policy.filiter.PolicyFilterHandler;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 访问控制RAM（Resource Access Management）
 * 管理用户身份与资源访问权限
 *
 * @author fobgo
 * @date 2021/9/29 15:28
 */
public class AfterAuthenticationFilter extends OncePerRequestFilter {

    private static final Logger logger = LoggerFactory.getLogger(AfterAuthenticationFilter.class);

    private final List<PolicyFilterHandler> policyHandlers;

    public AfterAuthenticationFilter(List<PolicyFilterHandler> policyHandlers) {
        this.policyHandlers = policyHandlers;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws ServletException, IOException {
        final TargetInfo targetInfo = TargetInfoContextHolder.getTargetInfo();
        targetInfo.initTargets();
        try {
            if (ResultType.IMPLICIT_DENY == targetInfo.getResultType()) {
                PolicyTypeChain policyTypeChain = new PolicyTypeChain(policyHandlers);
                ResultType result = policyTypeChain.doNextStep(targetInfo, request);
                targetInfo.setResultType(result);
                TargetInfoContextHolder.setContext(targetInfo);
            }
        } catch (Exception e) {
            logger.error("RAM after authentication filter handler error", e);
        }

        if (targetInfo.getResultType() == ResultType.EXPLICIT_DENY) {
            ExceptionUtils.writeUnAuth(request, response, Constant.APP_NAME, targetInfo.getResultType());
        } else {
            filterChain.doFilter(request, response);
        }
    }
}
