package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.constant.Constant;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.TargetInfoContextHolder;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyTypeChain;
import com.digiwin.dap.middle.ram.service.policy.filiter.PolicyFilterHandler;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 访问控制RAM（Resource Access Management）
 * 管理用户身份与资源访问权限
 *
 * @author fobgo
 * @date 2021/9/29 15:28
 */
public class BeforeAuthenticationFilter extends OncePerRequestFilter {

    private static final Logger logger = LoggerFactory.getLogger(BeforeAuthenticationFilter.class);

    private final List<PolicyFilterHandler> policyHandlers;

    public BeforeAuthenticationFilter(List<PolicyFilterHandler> policyHandlers) {
        this.policyHandlers = policyHandlers;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
            throws ServletException, IOException {
        final TargetInfo targetInfo = TargetInfoContextHolder.getTargetInfo();
        targetInfo.setObsolete(true);
        try {
            PolicyTypeChain policyTypeChain = new PolicyTypeChain(policyHandlers);
            ResultType result = policyTypeChain.doNextStep(targetInfo, request);
            targetInfo.setResultType(result);
            TargetInfoContextHolder.setContext(targetInfo);
        } catch (Exception e) {
            logger.error("RAM before authentication filter handler error", e);
        }

        try {
            if (targetInfo.getResultType() == ResultType.OBSOLETE_DENY) {
                ExceptionUtils.writeUnAuth(request, response, Constant.APP_NAME, targetInfo.getResultType());
            } else {
                filterChain.doFilter(request, response);
            }
        } finally {
            TargetInfoContextHolder.clearContext();
        }
    }
}
