package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;

import java.util.ArrayList;
import java.util.List;

/**
 * 存放策略设定的pattern，和当前访问request进行匹配
 *
 * @author fobgo
 * @date 2021/12/3 13:44
 */
public class MappingRegistry {

    private static final PathMatcher pathMatcher = new AntPathMatcher();
    /**
     * pattern，如：
     * /api/iam/v2/user/{sid}
     * /api/iam/v2/tenant/**
     */
    private final List<PatternVO> mappings = new ArrayList<>();
    /**
     * 直接路径，如：
     * /api/iam/v2/identity/login
     * /api/iam/v2/identity/token/analyze
     */
    private final MultiValueMap<String, PatternVO> urlLookup = new LinkedMultiValueMap<>();

    public MappingRegistry() {
    }

    public MappingRegistry(List<PatternVO> mappings) {
        for (PatternVO mapping : mappings) {
            if (pathMatcher.isPattern(mapping.getPath())) {
                this.mappings.add(mapping);
            } else {
                this.urlLookup.add(mapping.getPath(), mapping);
            }
        }
    }

    public static PathMatcher getPathMatcher() {
        return pathMatcher;
    }

    public List<PatternVO> getMappings() {
        return this.mappings;
    }

    public List<PatternVO> getMappingsByUrl(String urlPath) {
        return this.urlLookup.get(urlPath);
    }

    public boolean isEmpty() {
        return mappings.isEmpty() && urlLookup.isEmpty();
    }
}
