package com.digiwin.dap.middle.ram.interceptor;

import com.digiwin.dap.middle.ram.constant.Constant;
import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.TargetInfoContextHolder;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyTypeChain;
import com.digiwin.dap.middle.ram.service.policy.PolicyHandler;
import com.digiwin.dap.middleware.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

public class PreHandleInterceptor implements HandlerInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(PreHandleInterceptor.class);

    private final List<? extends PolicyHandler> policyHandlers;

    public PreHandleInterceptor(List<? extends PolicyHandler> policyHandlers) {
        this.policyHandlers = policyHandlers;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        final TargetInfo targetInfo = TargetInfoContextHolder.getTargetInfo();
        try {
            if (ResultType.IMPLICIT_DENY == targetInfo.getResultType()) {
                Object path = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
                PatternVO patternVO = new PatternVO(request.getMethod(), String.valueOf(path));
                targetInfo.setPattern(patternVO);

                PolicyTypeChain policyTypeChain = new PolicyTypeChain(policyHandlers);
                ResultType resultType = policyTypeChain.doNextStep(targetInfo, request);
                targetInfo.setResultType(resultType);
            }
        } catch (Exception e) {
            logger.error("RAM interceptor handler error", e);
        }

        if (targetInfo.getResultType() == ResultType.ALLOW) {
            return true;
        } else {
            ExceptionUtils.writeUnAuth(request, response, Constant.APP_NAME, targetInfo.getResultType());
            return false;
        }
    }
}
