package com.digiwin.dap.middle.ram.service;

import com.digiwin.dap.middle.ram.constant.CacheConstant;
import com.digiwin.dap.middle.ram.filter.MappingRegistry;
import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.service.executor.GrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@CacheConfig(cacheNames = CacheConstant.CACHE_NAME_POLICY, cacheManager = CacheConstant.CACHE_MANAGER)
@Service
public class PolicyQueryService {

    @Autowired
    private GrantExecutor grantExecutor;
    @Autowired
    private PolicyExecutor policyExecutor;

    @Cacheable(key = "#policyType")
    public MappingRegistry getPattern(String policyType) {
        List<PatternVO> patterns = policyExecutor.findPolicyByType(policyType);
        return new MappingRegistry(patterns);
    }

    public Statement getTargetPolicy(String policyType, String targetType, String targetId) {
        List<PatternVO> routes = new ArrayList<>();
        List<String> policyIds = grantExecutor.findPolicyIdByTarget(policyType, targetType, targetId);
        for (String policyId : policyIds) {
            routes.addAll(policyExecutor.findPolicyById(policyType, policyId));
        }
        return new Statement(routes);
    }

    public List<String> findPolicyIdByPath(String policyType, String method, String path) {
        return policyExecutor.findPolicyIdByPath(policyType, method, path);
    }
}

