package com.digiwin.dap.middle.ram.service.executor;

import com.digiwin.dap.middle.ram.constant.CacheConstant;
import com.digiwin.dap.middle.ram.domain.PatternVO;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstant.CACHE_NAME_POLICY, cacheManager = CacheConstant.CACHE_MANAGER)
public class PolicyCachingExecutor implements PolicyExecutor {

    private final PolicyExecutor delegate;

    public PolicyCachingExecutor(PolicyExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "#policyType + ':' + #policyId")
    @Override
    public List<PatternVO> findPolicyById(String policyType, String policyId) {
        return delegate.findPolicyById(policyType, policyId);
    }

    @Cacheable(key = "#policyType")
    @Override
    public List<PatternVO> findPolicyByType(String policyType) {
        return delegate.findPolicyByType(policyType);
    }

    @Cacheable(key = "#policyType + ':{' + #method + ' ' + #path + '}'")
    @Override
    public List<String> findPolicyIdByPath(String policyType, String method, String path) {
        return delegate.findPolicyIdByPath(policyType, method, path);
    }
}

