package com.digiwin.dap.middle.ram.service.executor;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.mapper.RamPolicyMapper;

import java.util.List;

public class PolicySimpleExecutor implements PolicyExecutor {

    private final RamPolicyMapper ramPolicyMapper;

    public PolicySimpleExecutor(RamPolicyMapper ramPolicyMapper) {
        this.ramPolicyMapper = ramPolicyMapper;
    }

    @Override
    public List<PatternVO> findPolicyById(String policyType, String policyId) {
        return ramPolicyMapper.findPolicyById(policyId);
    }

    @Override
    public List<PatternVO> findPolicyByType(String policyType) {
        return ramPolicyMapper.findPolicyByType(policyType);
    }

    @Override
    public List<String> findPolicyIdByPath(String policyType, String method, String path) {
        return ramPolicyMapper.findPolicyIdByPath(policyType, method, path);
    }
}

