package com.digiwin.dap.middle.ram.service.policy.filiter;

import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.policy.PolicyHandler;
import com.digiwin.dap.middle.ram.util.MatcherUtils;

import javax.servlet.http.HttpServletRequest;

/**
 * 过滤器处理策略
 *
 * @author fobgo
 * @date 2021/9/28 18:12
 */
public abstract class PolicyFilterHandler implements PolicyHandler {

    protected PolicyQueryService policyQueryService;

    public PolicyFilterHandler() {
    }

    public PolicyFilterHandler(PolicyQueryService policyQueryService) {
        this.policyQueryService = policyQueryService;
    }

    public ResultType matches(String targetType, String targetId, HttpServletRequest request) {
        return ResultType.IMPLICIT_DENY;
    }

    protected ResultType matches(String policyType, String targetType, String targetId, HttpServletRequest request) {
        Statement statement = policyQueryService.getTargetPolicy(policyType, targetType, targetId);
        if (!statement.getDeny().isEmpty()) {
            boolean matched = MatcherUtils.matches(request, statement.getDeny());
            if (matched) {
                return ResultType.EXPLICIT_DENY;
            }
        }
        if (!statement.getAllow().isEmpty()) {
            boolean matched = MatcherUtils.matches(request, statement.getAllow());
            if (matched) {
                return ResultType.ALLOW;
            }
        }
        return ResultType.IMPLICIT_DENY;
    }
}
