package com.digiwin.dap.middle.ram.service.policy.interceptor;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.function.Function;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import org.springframework.core.annotation.Order;

import java.util.List;

/**
 * 功能权限，策略类型 {@link PolicyType#Function}
 * <p>
 * 用户拥有对应功能权限即拥有对应的API访问权限
 * <p>
 * 此类型下策略ID即作业(actionId)或状态ID(conditionId)
 *
 * @author fobgo
 * @date 2021/9/18 21:04
 */
@Order(11)
public class FunctionPolicyInterceptorHandler extends PolicyInterceptorHandler {

    public FunctionPolicyInterceptorHandler(PolicyQueryService policyQueryService) {
        super(policyQueryService);
    }

    @Override
    public ResultType matches(TargetInfo targetInfo, PatternVO pattern) {
        List<String> actionIds = policyQueryService.findPolicyIdByPath(PolicyType.Function.name(), pattern.getMethod(), pattern.getPath());
        boolean match = Function.obtainPolicyIds(targetInfo.functionKey()).stream().anyMatch(actionIds::contains);
        if (match) {
            return ResultType.ALLOW;
        }
        return ResultType.IMPLICIT_DENY;
    }
}
