package com.digiwin.dap.middle.ram.service.policy.interceptor;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import org.springframework.core.annotation.Order;

/**
 * 合并结果处理
 * 开启{@see ObsoletePolicyFilterHandler}策略时，默认为值为{@link ResultType#ALLOW}
 *
 * @author fobgo
 * @date 2021/9/18 21:04
 */
@Order(19)
public class MergePolicyInterceptorHandler extends PolicyInterceptorHandler {

    @Override
    public ResultType matches(TargetInfo targetInfo, PatternVO pattern) {
        if (targetInfo.isObsolete() && targetInfo.getResultType() == ResultType.IMPLICIT_DENY) {
            return ResultType.ALLOW;
        }
        return targetInfo.getResultType();
    }
}
