package com.digiwin.dap.middle.ram.service.policy.interceptor;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.PolicyQueryService;
import com.digiwin.dap.middle.ram.service.policy.PolicyHandler;

import javax.servlet.http.HttpServletRequest;

/**
 * 拦截器处理策略
 *
 * @author fobgo
 * @date 2021/9/28 18:12
 */
public abstract class PolicyInterceptorHandler implements PolicyHandler {

    protected PolicyQueryService policyQueryService;

    public PolicyInterceptorHandler() {
    }

    public PolicyInterceptorHandler(PolicyQueryService policyQueryService) {
        this.policyQueryService = policyQueryService;
    }

    @Override
    public ResultType matches(TargetInfo targetInfo, HttpServletRequest request) {
        return matches(targetInfo, targetInfo.getPattern());
    }

    public ResultType matches(TargetInfo targetInfo, PatternVO pattern) {
        return ResultType.IMPLICIT_DENY;
    }
}
