package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.entity.BaseEntity;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;

import java.time.LocalDateTime;

public class BaseUtils {
    public BaseUtils() {
    }

    public static AuthoredUser getAuthoredUser() {
        AppAuthContext context = AppAuthContextHolder.getContext();
        return context.getAuthoredUser() != null ? context.getAuthoredUser() : null;
    }

    public static AuthoredSys getAuthoredSys() {
        AppAuthContext context = AppAuthContextHolder.getContext();
        return context.getAuthoredSys() != null ? context.getAuthoredSys() : null;
    }

    public static String getToken() {
        AuthoredUser authoredUser = getAuthoredUser();
        return authoredUser != null ? authoredUser.getToken() : null;
    }

    public static long getUserSid() {
        AuthoredUser authoredUser = getAuthoredUser();
        return authoredUser != null ? authoredUser.getSid() : 0L;
    }

    public static String getUserId() {
        AuthoredUser authoredUser = getAuthoredUser();
        return authoredUser != null ? authoredUser.getUserId() : null;
    }

    public static String getUserName() {
        AuthoredUser authoredUser = getAuthoredUser();
        return authoredUser != null ? authoredUser.getUserName() : null;
    }

    public static long getTenantSid() {
        AuthoredUser authoredUser = getAuthoredUser();
        return authoredUser != null ? authoredUser.getTenantSid() : 0L;
    }

    public static String getTenantId() {
        AuthoredUser authoredUser = getAuthoredUser();
        return authoredUser != null ? authoredUser.getTenantId() : null;
    }

    public static String getTenantName() {
        AuthoredUser authoredUser = getAuthoredUser();
        return authoredUser != null ? authoredUser.getTenantName() : null;
    }

    public static long getSysSid() {
        AuthoredSys authoredSys = getAuthoredSys();
        return authoredSys != null ? authoredSys.getSid() : 0L;
    }

    public static String getSysId() {
        AuthoredSys authoredSys = getAuthoredSys();
        return authoredSys != null ? authoredSys.getId() : null;
    }

    public static void setCreateFields(BaseEntity entity) {
        entity.setCreateBy(getUserSid());
        entity.setCreateById(getUserName());
        entity.setCreateDate(LocalDateTime.now());
        entity.setModifyBy(getUserSid());
        entity.setModifyById(getUserName());
        entity.setModifyDate(LocalDateTime.now());
    }

    public static void setModifyFields(BaseEntity entity) {
        entity.setModifyBy(getUserSid());
        entity.setModifyById(getUserName());
        entity.setModifyDate(LocalDateTime.now());
    }
}
