package com.digiwin.dap.middle.ram.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;

/**
 * 文件处理
 *
 * @author Xiao
 * @date 2021/8/16 18:19
 */
public class FileUtils {

    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    private final static int DEFAULT_BUFFER_SIZE = 1024 * 4;

    public static String readFromResource(String resource) throws IOException {
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (in == null) {
                in = FileUtils.class.getResourceAsStream(resource);
            }
            if (in == null) {
                return null;
            }
            return FileUtils.read(in);
        } finally {
            in.close();
        }
    }

    public static String read(InputStream in) {
        InputStreamReader reader;
        reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return read(reader);
    }

    public static String read(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[DEFAULT_BUFFER_SIZE];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        } catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }
}
