package com.digiwin.dap.middle.ram.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * JdbcUtils
 *
 * @author Xiao
 * @date 2021/8/16 18:22
 */
public class JdbcUtils {

    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);
    private static final String QUERY_TABLE_EXISTS = "show tables like '%s'";

    public static void createTables(JdbcTemplate jdbcTemplate) {
        String[] resources = new String[]{
                "ram_grant", "ram_grant_policy",
                "ram_policy", "ram_policy_route",
                "ram_route"
        };
        for (String table : resources) {
            String path = "/support/" + table + ".sql";
            try {
                final boolean next = jdbcTemplate.queryForRowSet(String.format(QUERY_TABLE_EXISTS, table)).next();
                if (next) {
                    logger.warn("table {} has been created.", table);
                } else {
                    String tableInfo = FileUtils.readFromResource(path);
                    jdbcTemplate.execute(tableInfo);
                }
            } catch (Exception e) {
                logger.error("create table error {}", e.getMessage());
            }
        }
    }

    public static void initData(JdbcTemplate jdbcTemplate) {
        execSql(jdbcTemplate, "standard");
    }

    public static void initTemp(JdbcTemplate jdbcTemplate) {
        execSql(jdbcTemplate, "standard_temp");
    }

    public static void execSql(JdbcTemplate jdbcTemplate, String file) {
        String path = "/support/" + file + ".sql";
        try {
            String sqls = FileUtils.readFromResource(path);
            exec(jdbcTemplate, sqls);
        } catch (Exception e) {
            logger.error("init data error {}", e.getMessage());
        }
    }

    public static void exec(JdbcTemplate jdbcTemplate, String sqls) {
        String[] sqlArray = sqls.split(";");
        for (String sql : sqlArray) {
            jdbcTemplate.execute(sql);
        }
    }
}
