package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.serializer.LocalDateDeserializer;
import com.digiwin.dap.middle.ram.serializer.LocalDateSerializer;
import com.digiwin.dap.middle.ram.serializer.LocalDateTimeDeserializer;
import com.digiwin.dap.middle.ram.serializer.LocalDateTimeSerializer;
import com.digiwin.dap.middle.ram.serializer.LocalTimeDeserializer;
import com.digiwin.dap.middle.ram.serializer.LocalTimeSerializer;
import com.digiwin.dap.middle.ram.serializer.TimestampDeserializer;
import com.digiwin.dap.middle.ram.serializer.TimestampSerializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

/**
 * JsonUtils.java
 *
 * @author Xiao
 * @date 2021/8/19 15:26
 */
public class JsonUtils {

    private static volatile ObjectMapper objectMapper = null;

    public static RedisSerializer<Object> getRedisSerializer(boolean... enableDefaultTyping) {
        ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json()
                .serializationInclusion(JsonInclude.Include.NON_NULL)
                .simpleDateFormat("yyyy-MM-dd HH:mm:ss")
                .failOnUnknownProperties(false)
                .failOnEmptyBeans(false)
                .modules(getJavaTimeModule())
                .build();
        // 允许出现特殊字符和转义符
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        // 允许出现单引号
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);

        if (enableDefaultTyping.length > 0 && enableDefaultTyping[0]) {
            // 启用反序列化所需的類型信息,在屬性中添加@class
            objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
        }

        Jackson2JsonRedisSerializer<Object> serializer = new Jackson2JsonRedisSerializer<>(Object.class);
        serializer.setObjectMapper(objectMapper);
        return serializer;
    }

    public static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            synchronized (JsonUtils.class) {
                if (objectMapper == null) {
                    objectMapper = Jackson2ObjectMapperBuilder.json()
                            .serializationInclusion(JsonInclude.Include.NON_NULL)
                            .simpleDateFormat("yyyy-MM-dd HH:mm:ss")
                            .failOnUnknownProperties(false)
                            .failOnEmptyBeans(false)
                            .modules(getJavaTimeModule())
                            .build();
                    // 允许出现特殊字符和转义符
                    objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
                    // 允许出现单引号
                    objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
                    objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
                }
            }
        }
        return objectMapper;
    }

    private static JavaTimeModule getJavaTimeModule() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDate.class, new LocalDateSerializer());
        javaTimeModule.addDeserializer(LocalDate.class, new LocalDateDeserializer());
        javaTimeModule.addSerializer(LocalDateTime.class, new LocalDateTimeSerializer());
        javaTimeModule.addDeserializer(LocalDateTime.class, new LocalDateTimeDeserializer());
        javaTimeModule.addSerializer(LocalTime.class, new LocalTimeSerializer());
        javaTimeModule.addDeserializer(LocalTime.class, new LocalTimeDeserializer());
        javaTimeModule.addSerializer(Timestamp.class, new TimestampSerializer());
        javaTimeModule.addDeserializer(Timestamp.class, new TimestampDeserializer());
        return javaTimeModule;
    }
}
