package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.constant.ErrorHead;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * RedisCache.java
 *
 * @author Xiao
 * @date 2021/8/19 16:15
 */
public class RedisUtils {
    private static final Logger logger = LoggerFactory.getLogger(RedisUtils.class);
    private static final ObjectMapper objectMapper = JsonUtils.getObjectMapper();

    private static RedisTemplate<String, Object> redisTemplate;

    public static void initTemplate(RedisTemplate<String, Object> redisTemplate) {
        RedisUtils.redisTemplate = redisTemplate;
    }

    public static <T> T get(Object key, Class<T> type) {
        try {
            Object obj = redisTemplate.opsForValue().get(key);
            if (obj != null) {
                return objectMapper.readValue(obj.toString().getBytes(StandardCharsets.UTF_8), type);
            }
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
        return null;
    }

    public static Set<String> getKeys(String pattern) {
        try {
            return redisTemplate.keys(pattern);
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
        return null;
    }

    public static void put(String key, Object value) {
        try {
            redisTemplate.opsForValue().set(key, value);
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
    }

    public static void put(String key, Object value, Duration duration) {
        try {
            redisTemplate.opsForValue().set(key, value, duration);
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
    }

    public static Long getExpire(String key) {
        try {
            return redisTemplate.getExpire(key);
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
        return null;
    }

    public static Long getExpire(String key, TimeUnit timeUnit) {
        try {
            return redisTemplate.getExpire(key, timeUnit);
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
        return null;
    }

    public static void expire(String key, long timeout, TimeUnit unit) {
        try {
            redisTemplate.expire(key, timeout, unit);
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
    }

    public static boolean hasKey(String key) {
        try {
            Boolean result = redisTemplate.hasKey(key);
            return Objects.equals(result, Boolean.TRUE);
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
        return false;
    }

    public static void delete(String key) {
        try {
            redisTemplate.delete(key);
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
    }

    public static Long delete(Collection<String> keys) {
        try {
            return redisTemplate.delete(keys);
        } catch (Exception e) {
            logger.error("{}{}", ErrorHead.REDIS, e.getMessage());
        }
        return 0L;
    }
}
