CREATE TABLE ram_grant
(
    sid          BIGINT(20)   NOT NULL,
    type         VARCHAR(10)  NOT NULL COMMENT '目标类型',
    target_id    VARCHAR(100) NOT NULL COMMENT '被授权目标',
    create_by    BIGINT(20)   NULL DEFAULT '0' COMMENT '创建人',
    create_by_id VARCHAR(255) NULL DEFAULT NULL COMMENT '创建人',
    create_date  DATETIME     NULL DEFAULT NULL COMMENT '创建日期',
    modify_by    BIGINT(20)   NULL DEFAULT '0' COMMENT '修改人',
    modify_by_id VARCHAR(255) NULL DEFAULT NULL COMMENT '修改人',
    modify_date  DATETIME     NULL DEFAULT NULL COMMENT '修改日期',
    PRIMARY KEY (sid) USING BTREE,
    UNIQUE INDEX uk_type_targetid (type, target_id) USING BTREE
);
