/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.access;

import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.access.PolicyHandler;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import java.util.List;

public final class PolicyTypeChain {
    private final List<? extends PolicyHandler> policyHandlers;
    private final int size;
    private int currentPosition = 0;

    public PolicyTypeChain(List<? extends PolicyHandler> policyHandlers) {
        this.policyHandlers = policyHandlers;
        this.size = policyHandlers.size();
    }

    public ResultType doNextStep(AppAuthContext context, RequestInfo request) {
        if (this.currentPosition == this.size) {
            return ResultType.IMPLICIT_DENY;
        }
        ++this.currentPosition;
        PolicyHandler nextPolicyHandler = this.policyHandlers.get(this.currentPosition - 1);
        ResultType resultType = nextPolicyHandler.matches(context, request);
        if (ResultType.IMPLICIT_DENY == resultType) {
            return this.doNextStep(context, request);
        }
        return resultType;
    }
}

