/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.authentication;

import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandler;
import com.digiwin.dap.middle.ram.service.authentication.AuthCheckService;
import com.digiwin.dap.middle.ram.service.authentication.handler.BeforeAuthCheckHandler;
import com.digiwin.dap.middle.ram.service.authentication.handler.DoAuthCheckHandler;
import com.digiwin.dap.middle.ram.service.authentication.handler.NoAuthAppAuthCheckHandler;
import com.digiwin.dap.middle.ram.service.authentication.handler.NoAuthAuthCheckHandler;
import com.digiwin.dap.middle.ram.service.authentication.handler.NoAuthUserAuthCheckHandler;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class AuthCheckHandlerComposite
extends AuthCheckHandler {
    private final List<AuthCheckHandler> handlers = new ArrayList<AuthCheckHandler>(5);

    public AuthCheckHandlerComposite(AuthCheckService authCheckService, RamCoreService ramCoreService) {
        this.handlers.add(new BeforeAuthCheckHandler(ramCoreService));
        this.handlers.add(new NoAuthAuthCheckHandler(ramCoreService));
        this.handlers.add(new DoAuthCheckHandler(authCheckService));
        this.handlers.add(new NoAuthAppAuthCheckHandler(ramCoreService));
        this.handlers.add(new NoAuthUserAuthCheckHandler(ramCoreService));
        AnnotationAwareOrderComparator.sort(this.handlers);
    }

    @Override
    public boolean supports(AuthType authType) {
        return false;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys, RequestInfo request) {
        for (AuthCheckHandler handler : this.handlers) {
            if (!handler.supports(authResult.getAuthType())) continue;
            AuthResult temp = handler.processAuth(authResult, user, sys, request);
            if (temp.getAuthType() == AuthType.AppOk) {
                return temp;
            }
            authResult = temp;
        }
        return authResult;
    }
}

