/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.domain.function;

import com.digiwin.dap.middle.ram.domain.function.FunctionPermission;
import com.digiwin.dap.middle.ram.domain.function.FunctionQuery;
import com.digiwin.dap.middle.ram.domain.function.FunctionResult;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.cache.RedisUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Function {
    public static final String REDIS_PERMISSION_KEY = "iam:permission:all:%s::%s::%s";
    private FunctionQuery query = new FunctionQuery();
    private FunctionResult result = new FunctionResult();

    public static List<String> obtainPolicyIds(AuthoredUser user, AuthoredSys sys) {
        return Function.obtainPolicyIds(user.getUserId(), user.getTenantId(), sys.getId());
    }

    public static List<String> obtainPolicyIds(String userId, String tenantId, String sysId) {
        String key = String.format(REDIS_PERMISSION_KEY, userId, tenantId, sysId);
        ArrayList<String> policyIds = new ArrayList<String>();
        Function function = (Function)RedisUtils.get((Object)key, Function.class);
        if (function == null || function.getResult() == null) {
            return policyIds;
        }
        String appId = function.getQuery().getTarget();
        policyIds.add(appId);
        List moduleIds = function.getResult().getPermissions().stream().map(p -> appId + ":" + p.getModuleId()).distinct().collect(Collectors.toList());
        policyIds.addAll(moduleIds);
        for (FunctionPermission action : function.getResult().getPermissions()) {
            policyIds.add(action.getTarget());
            for (Map.Entry<String, Map<String, String>> condition : action.getConditions().entrySet()) {
                for (Map.Entry<String, String> conditionValue : condition.getValue().entrySet()) {
                    policyIds.add(condition.getKey() + ":" + conditionValue.getValue());
                }
            }
        }
        return policyIds;
    }

    public FunctionQuery getQuery() {
        return this.query;
    }

    public void setQuery(FunctionQuery query) {
        this.query = query;
    }

    public FunctionResult getResult() {
        return this.result;
    }

    public void setResult(FunctionResult result) {
        this.result = result;
    }
}

