/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.access.policy;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.access.TargetTypeChain;
import com.digiwin.dap.middle.ram.service.access.policy.PolicyFilterHandler;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.Order;

@Order(value=300)
public class BasePolicyFilterHandler
extends PolicyFilterHandler {
    public BasePolicyFilterHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public ResultType matches(AppAuthContext context, RequestInfo request) {
        return TargetTypeChain.getInstance(this, TargetInfo.getTargets(context)).matches(request);
    }

    @Override
    public ResultType matches(String targetType, String targetId, RequestInfo request) {
        PatternVO matched;
        Statement statement = this.ramCoreService.getPolicyRoute(request.getAppId(), PolicyType.Base.name(), targetType, targetId);
        if (!statement.getDeny().isEmpty() && (matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getDeny())) != null) {
            return ResultType.EXPLICIT_DENY;
        }
        if (!statement.getAllow().isEmpty() && (matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow())) != null) {
            return ResultType.ALLOW;
        }
        return ResultType.IMPLICIT_DENY;
    }
}

