/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.authentication.handler;

import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandler;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import java.util.List;
import org.springframework.core.annotation.Order;

@Order(value=20)
public class NoAuthUserAuthCheckHandler
extends AuthCheckHandler {
    public NoAuthUserAuthCheckHandler(RamCoreService ramCoreService) {
        this.ramCoreService = ramCoreService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return authType == AuthType.AppNoneUser;
    }

    @Override
    public AuthResult processAuth(AuthResult authResult, AuthoredUser user, AuthoredSys sys, RequestInfo request) {
        List<String> policyId = this.ramCoreService.findPolicyId(request.getAppId(), PolicyType.NoAuthUser.name(), TargetType.Sys.name(), sys.getId());
        if (!policyId.isEmpty()) {
            authResult.setAuthType(AuthType.AppOk);
        } else {
            policyId = this.ramCoreService.findPolicyId(request.getAppId(), PolicyType.NoAuthUser.name(), TargetType.TenantSys.name(), user.getTenantId() + '-' + sys.getId());
            if (!policyId.isEmpty()) {
                authResult.setAuthType(AuthType.AppOk);
            }
        }
        return authResult;
    }
}

