/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.domain.page.Page;
import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.entity.Grant;
import com.digiwin.dap.middle.ram.mapper.RamGrantMapper;
import com.digiwin.dap.middle.ram.service.base.RamGrantCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamGrantCrudServiceImpl
implements RamGrantCrudService {
    @Autowired
    private RamGrantMapper ramGrantMapper;

    @Override
    public long insert(Grant data) {
        data.setSid(SnowFlake.getInstance().newId());
        BaseUtils.setCreateFields(data);
        this.ramGrantMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramGrantMapper.deleteBySid(sid);
    }

    @Override
    public long update(Grant data) {
        BaseUtils.setCreateFields(data);
        this.ramGrantMapper.update(data);
        return data.getSid();
    }

    @Override
    public Grant findBySid(long sid) {
        return this.ramGrantMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Grant data) {
        return this.ramGrantMapper.exists(data.getSid());
    }

    @Override
    public List<Grant> findByCond(Grant data) {
        return this.ramGrantMapper.findByCond(data);
    }

    @Override
    public PageData<GrantVO> findByPage(Page<Grant> page) {
        Filter<Grant> filter = page.filter();
        long total = this.ramGrantMapper.countByPage(filter.getEq(), filter);
        if (total == 0L) {
            return PageData.empty();
        }
        List<GrantVO> paths = this.ramGrantMapper.findByPage(filter.getEq(), filter);
        return PageData.data(total, paths);
    }
}

