/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.core.impl;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.mapper.RamExecutorMapper;
import com.digiwin.dap.middle.ram.service.MappingInfoRegistry;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.service.executor.GrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import com.digiwin.dap.middle.ram.service.executor.RouteExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamCoreServiceImpl
implements RamCoreService {
    @Autowired
    private GrantExecutor grantExecutor;
    @Autowired
    private RouteExecutor routeExecutor;
    @Autowired
    private PolicyExecutor policyExecutor;
    @Autowired
    private RamExecutorMapper ramExecutorMapper;
    @Autowired
    private MappingInfoRegistry mappingInfoRegistry;

    @Override
    public MappingRegistry getPattern(String appId) {
        List<PatternVO> patterns = this.routeExecutor.findRouteByApp(appId);
        return new MappingRegistry(patterns, this.mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public MappingRegistry getPattern(String appId, String policyType) {
        List<PatternVO> patterns = this.policyExecutor.findRouteByPolicyType(appId, policyType);
        return new MappingRegistry(patterns, this.mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public Statement getPolicyRoute(String appId, List<String> policyIds) {
        ArrayList<PatternVO> routes = new ArrayList<PatternVO>();
        for (String policyId : policyIds) {
            routes.addAll(this.policyExecutor.findRouteByPolicyId(appId, policyId));
        }
        return new Statement(routes, this.mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public Statement getPolicyRoute(String appId, String policyType, String targetType, String targetId) {
        ArrayList<PatternVO> routes = new ArrayList<PatternVO>();
        List<String> policyIds = this.findPolicyId(appId, policyType, targetType, targetId);
        for (String policyId : policyIds) {
            routes.addAll(this.policyExecutor.findRouteByPolicyId(appId, policyId));
        }
        return new Statement(routes, this.mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public List<String> findPolicyIdByRoute(String appId, String policyType, String method, String path) {
        List<PolicyVO> policies = this.policyExecutor.findPolicyIdByRoute(appId, method, path);
        return policies.stream().filter(o -> policyType.equals(o.getType())).map(PolicyVO::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> findPolicyIdByRoute(String appId, String method, String path) {
        return this.findPolicyIdByRoute(appId, PolicyType.Function.name(), method, path);
    }

    @Override
    public List<String> findPolicyId(String appId, String policyType, String targetType, String targetId) {
        List<PolicyVO> policies = this.grantExecutor.findPolicyIdByTarget(appId, targetType, targetId);
        return policies.stream().filter(o -> policyType.equals(o.getType())).map(PolicyVO::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> findTargetIdByRoute(String appId, String policyType, String targetType, String method, String path) {
        List<String> policyIds = this.findPolicyIdByRoute(appId, policyType, method, path);
        ArrayList<String> targetIds = new ArrayList<String>();
        for (String policyId : policyIds) {
            List<GrantVO> grants = this.ramExecutorMapper.findTargetByPolicyId(appId, targetType, policyId);
            grants.stream().map(GrantVO::getTargetId).forEach(targetIds::add);
        }
        return targetIds;
    }
}

