/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcUtils {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUtils.class);
    private static final String QUERY_TABLE_EXISTS = "show tables like '%s'";
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void createTables(JdbcTemplate jdbcTemplate) {
        String[] resources;
        for (String table : resources = new String[]{"ram_grant", "ram_grant_policy", "ram_policy", "ram_policy_route", "ram_route"}) {
            String path = "/support/" + table + ".sql";
            try {
                boolean next = jdbcTemplate.queryForRowSet(String.format(QUERY_TABLE_EXISTS, table)).next();
                if (next) {
                    logger.debug("table {} has been created.", (Object)table);
                    continue;
                }
                String tableInfo = JdbcUtils.readFromResource(path);
                jdbcTemplate.execute(tableInfo);
            }
            catch (Exception e) {
                logger.error("create table error {}", (Object)e.getMessage());
            }
        }
    }

    private static String readFromResource(String resource) throws IOException {
        try (InputStream in = null;){
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (in == null) {
                in = JdbcUtils.class.getResourceAsStream(resource);
            }
            if (in == null) {
                String string = null;
                return string;
            }
            String string = JdbcUtils.read(in);
            return string;
        }
    }

    private static String read(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return JdbcUtils.read(reader);
    }

    private static String read(Reader reader) {
        try {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        }
        catch (IOException ex) {
            throw new IllegalStateException("read error", ex);
        }
    }
}

