package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.entity.Route;
import org.springframework.util.StringUtils;

import java.util.Objects;

/**
 * API缓存
 *
 * @author fobgochod
 * @date 2021/9/26 17:09
 */
public class PatternVO {

    private String method;
    private String path;
    private String tableName;
    private Boolean effect;

    public PatternVO() {
    }

    public PatternVO(Route route) {
        this.method = route.getMethod();
        this.path = route.getPath();
        this.tableName = route.getTableName();
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Boolean getEffect() {
        return effect;
    }

    public void setEffect(Boolean effect) {
        this.effect = effect;
    }

    public String path() {
        return StringUtils.hasLength(tableName) ? path + "/" + tableName : path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PatternVO patternVO = (PatternVO) o;
        return Objects.equals(method, patternVO.method) && path.equals(patternVO.path) && Objects.equals(tableName, patternVO.tableName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(method, path, tableName);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (StringUtils.hasLength(method)) {
            builder.append(method);
        }
        builder.append("-").append(path);
        if (StringUtils.hasLength(tableName)) {
            builder.append("/").append(tableName);
        }
        builder.append("}");
        return builder.toString();
    }
}
