package com.digiwin.dap.middle.ram.domain;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;

import java.util.ArrayList;
import java.util.List;

public class TargetInfo {

    private TargetType targetType;
    private String targetId;

    public TargetInfo() {
    }

    public TargetInfo(TargetType targetType, String targetId) {
        this.targetType = targetType;
        this.targetId = targetId;
    }

    /**
     * 有序，按照用户->租户->应用依次校验
     */
    public static List<TargetInfo> getTargets(AppAuthContext context) {
        List<TargetInfo> targets = new ArrayList<>();
        AuthoredUser user = context.getAuthoredUser();
        if (user != null) {
            targets.add(new TargetInfo(TargetType.User, user.getUserId()));
            if (user.getTenantId() != null) {
                targets.add(new TargetInfo(TargetType.Tenant, user.getTenantId()));
            }
        }
        AuthoredSys sys = context.getAuthoredSys();
        if (sys != null) {
            targets.add(new TargetInfo(TargetType.Sys, sys.getId()));
        }
        return targets;
    }

    public TargetType getTargetType() {
        return targetType;
    }

    public void setTargetType(TargetType targetType) {
        this.targetType = targetType;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }
}
