package com.digiwin.dap.middle.ram.domain.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 策略类型
 *
 * @author fobgochod
 * @date 2021/8/16 15:37
 */
public enum PolicyType {

    /**
     * 不做权限管控，只有唯一一个策略
     */
    None,
    /**
     * 白名单
     */
    AllowList,
    /**
     * 策略，系统策略(System)、自定义策略(Custom)
     */
    Base,

    /**
     * 跨租户访问管控
     */
    AcrossTenant,

    /**
     * 功能权限策略
     */
    Function,


    /**
     * 啥也不需要
     * 不做授权检查
     */
    NoAuth,
    /**
     * 需要AppToken
     * <p>
     * 应用授权检查
     * 1、如果没有购买，直接放过
     * 2、购买了就检查过期时间
     */
    NoAuthApp,
    /**
     * 需要租户和AppToken
     * 用户授权检查
     * 1、租户需要购买应用
     * 2、不需要检查用户是否加入该应用
     */
    NoAuthUser;

    private static final Map<String, PolicyType> SOLES = new HashMap<>(3);

    static {
        SOLES.put(None.name(), None);
        SOLES.put(NoAuth.name(), NoAuth);
    }

    public static boolean isSole(String method) {
        return (method != null && SOLES.containsKey(method));
    }
}
