package com.digiwin.dap.middle.ram.service.access.policy;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import com.digiwin.dap.middle.ram.service.access.TargetTypeChain;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.domain.RequestInfo;
import org.springframework.core.annotation.Order;

/**
 * 白名单，策略类型 {@link PolicyType#AllowList}
 * <p>
 * 该策略下的API，目标设定拥有该策略才可以访问，其他目标一律不能访问
 *
 * @author fobgochod
 * @date 2021/9/18 21:04
 */
@Order(200)
public class AllowListPolicyFilterHandler extends PolicyFilterHandler {

    public AllowListPolicyFilterHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public ResultType matches(AppAuthContext context, RequestInfo request) {
        // 1.查询所有白名单API
        MappingRegistry mappingRegistry = ramCoreService.getPattern(request.getAppId(), PolicyType.AllowList.name());
        if (!mappingRegistry.isEmpty()) {
            // 2.当前访问API和白名单集合进行匹配
            PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry);
            if (matched != null) {
                // 2.1.当前API在白名单集合中，依次进行匹配
                ResultType resultType = TargetTypeChain.getInstance(this, TargetInfo.getTargets(context)).matches(request);
                // 3.有则允许，没有则拒绝
                return resultType == ResultType.ALLOW ? ResultType.ALLOW : ResultType.EXPLICIT_DENY;
            }
        }
        // 2.2.当前API不在白名单集合中
        return ResultType.IMPLICIT_DENY;
    }

    @Override
    public ResultType matches(String targetType, String targetId, RequestInfo request) {
        Statement statement = ramCoreService.getPolicyRoute(request.getAppId(), PolicyType.AllowList.name(), targetType, targetId);
        if (!statement.getAllow().isEmpty()) {
            PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow());
            if (matched != null) {
                return ResultType.ALLOW;
            }
        }
        return ResultType.IMPLICIT_DENY;
    }
}
