package com.digiwin.dap.middle.ram.service.authentication;

import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;

/**
 * 通过appToken检查访问者是否有应用授权
 *
 * @author fobgochod
 * @date 2022/1/25 9:17
 */
public interface AuthCheckService {

    /**
     * 返回授权结果
     * <p>
     * 0: 拥有授权
     * 1: 没有购买应用
     * 2: 已购买，但是应用过期
     * 3: 已购买、但是用户未加入
     *
     * @param authoredUser 登录用户
     * @param authoredSys  登录应用
     * @return {@link  AuthType}
     */
    AuthResult processAuth(AuthResult authResult, AuthoredUser authoredUser, AuthoredSys authoredSys);
}
