package com.digiwin.dap.middle.ram.service.core.impl;

import com.digiwin.dap.middle.ram.domain.GrantVO;
import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.mapper.RamExecutorMapper;
import com.digiwin.dap.middle.ram.service.MappingInfoRegistry;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.service.executor.GrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import com.digiwin.dap.middle.ram.service.executor.RouteExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class RamCoreServiceImpl implements RamCoreService {

    @Autowired
    private GrantExecutor grantExecutor;
    @Autowired
    private RouteExecutor routeExecutor;
    @Autowired
    private PolicyExecutor policyExecutor;
    @Autowired
    private RamExecutorMapper ramExecutorMapper;
    @Autowired
    private MappingInfoRegistry mappingInfoRegistry;

    @Override
    public MappingRegistry getPattern(String appId) {
        List<PatternVO> patterns = routeExecutor.findRouteByApp(appId);
        return new MappingRegistry(patterns, mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public MappingRegistry getPattern(String appId, String policyType) {
        List<PatternVO> patterns = policyExecutor.findRouteByPolicyType(appId, policyType);
        return new MappingRegistry(patterns, mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public Statement getPolicyRoute(String appId, List<String> policyIds) {
        List<PatternVO> routes = new ArrayList<>();
        for (String policyId : policyIds) {
            routes.addAll(policyExecutor.findRouteByPolicyId(appId, policyId));
        }
        return new Statement(routes, mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public Statement getPolicyRoute(String appId, String policyType, String targetType, String targetId) {
        List<PatternVO> routes = new ArrayList<>();
        List<String> policyIds = this.findPolicyId(appId, policyType, targetType, targetId);
        for (String policyId : policyIds) {
            routes.addAll(policyExecutor.findRouteByPolicyId(appId, policyId));
        }
        return new Statement(routes, mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public List<String> findPolicyIdByRoute(String appId, String policyType, String method, String path) {
        List<PolicyVO> policies = policyExecutor.findPolicyIdByRoute(appId, method, path);
        return policies.stream().filter(o -> policyType.equals(o.getType())).map(PolicyVO::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> findPolicyIdByRoute(String appId, String method, String path) {
        return findPolicyIdByRoute(appId, PolicyType.Function.name(), method, path);
    }

    @Override
    public List<String> findPolicyId(String appId, String policyType, String targetType, String targetId) {
        List<PolicyVO> policies = grantExecutor.findPolicyIdByTarget(appId, targetType, targetId);
        return policies.stream().filter(o -> policyType.equals(o.getType())).map(PolicyVO::getId).collect(Collectors.toList());
    }

    @Override
    public List<String> findTargetIdByRoute(String appId, String policyType, String targetType, String method, String path) {
        List<String> policyIds = this.findPolicyIdByRoute(appId, policyType, method, path);
        List<String> targetIds = new ArrayList<>();
        for (String policyId : policyIds) {
            List<GrantVO> grants = ramExecutorMapper.findTargetByPolicyId(appId, targetType, policyId);
            grants.stream().map(GrantVO::getTargetId).forEach(targetIds::add);
        }
        return targetIds;
    }
}
