package com.digiwin.dap.middle.ram.service.executor.cache;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.service.executor.PolicyExecutor;
import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class PolicyCachingExecutor implements PolicyExecutor {

    private final PolicyExecutor delegate;

    public PolicyCachingExecutor(PolicyExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #app + ':' + #policyType")
    @Override
    public List<PatternVO> findRouteByPolicyType(String app, String policyType) {
        return delegate.findRouteByPolicyType(app, policyType);
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #app + ':' + #policyId")
    @Override
    public List<PatternVO> findRouteByPolicyId(String app, String policyId) {
        return delegate.findRouteByPolicyId(app, policyId);
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.constant.CacheConstant).RAM_POLICY + #app + ':{' + #method + ' ' + #path + '}'")
    @Override
    public List<PolicyVO> findPolicyIdByRoute(String app, String method, String path) {
        return delegate.findPolicyIdByRoute(app, method, path);
    }
}
