package com.digiwin.dap.middle.ram.util;

import com.digiwin.dap.middle.ram.domain.PatternVO;
import com.digiwin.dap.middle.ram.domain.condition.MappingInfo;
import com.digiwin.dap.middle.ram.service.MappingRegistry;
import com.digiwin.dap.middleware.constant.InternalUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 路径匹配
 *
 * @author fobgochod
 * @date 2021/10/14 11:39
 */
public class MatcherUtils {

    private static final Logger logger = LoggerFactory.getLogger(MatcherUtils.class);

    public static Map<String, Boolean> policyAllows() {
        Map<String, Boolean> allowPath = new HashMap<>(6);
        allowPath.put(InternalUrl.LOGIN, Boolean.TRUE);
        allowPath.put(InternalUrl.INTEGRATION_LOGIN, Boolean.TRUE);
        allowPath.put(InternalUrl.TOKEN_ANALYZE, Boolean.TRUE);
        allowPath.put(InternalUrl.INTERNAL_TOKEN_ANALYZE, Boolean.TRUE);
        allowPath.put(InternalUrl.USER_SERVICE_ANALYZE, Boolean.TRUE);
        allowPath.put(InternalUrl.TENANT_SERVICE_ANALYZE, Boolean.TRUE);
        return allowPath;
    }

    public static Map<String, Boolean> authAllows() {
        Map<String, Boolean> allowPath = new HashMap<>(4);
        allowPath.put(InternalUrl.LOGIN, Boolean.TRUE);
        allowPath.put(InternalUrl.INTEGRATION_LOGIN, Boolean.TRUE);
        allowPath.put(InternalUrl.USER_SERVICE_ANALYZE, Boolean.TRUE);
        allowPath.put(InternalUrl.TENANT_SERVICE_ANALYZE, Boolean.TRUE);
        return allowPath;
    }

    public static boolean matches(HttpServletRequest request, MappingRegistry mappingRegistry) {
        String lookupPath = mappingRegistry.getUrlPathHelper().getLookupPathForRequest(request);

        List<MappingInfo> directPathMatches = mappingRegistry.getMappingsByUrl(lookupPath);
        if (directPathMatches != null) {
            for (MappingInfo mapping : directPathMatches) {
                MappingInfo match = mapping.getMatchingCondition(request);
                if (match != null) {
                    logger.debug("matched " + mapping);
                    return true;
                }
            }
        }

        for (MappingInfo mapping : mappingRegistry.getMappingLookup().keySet()) {
            MappingInfo match = mapping.getMatchingCondition(request);
            if (match != null) {
                logger.debug("matched " + mapping);
                return true;
            }
        }

        logger.debug("No matches found");
        return false;
    }

    public static PatternVO matches(String method, String lookupPath, MappingRegistry mappingRegistry) {
        List<MappingInfo> directPathMatches = mappingRegistry.getMappingsByUrl(lookupPath);
        if (directPathMatches != null) {
            for (MappingInfo mapping : directPathMatches) {
                MappingInfo match = mapping.getMatchingCondition(method, lookupPath);
                if (match != null) {
                    logger.debug("matched " + mapping);
                    return mappingRegistry.getRegistry().get(match);
                }
            }
        }

        for (MappingInfo mapping : mappingRegistry.getMappingLookup().keySet()) {
            MappingInfo match = mapping.getMatchingCondition(method, lookupPath);
            if (match != null) {
                logger.debug("matched " + mapping);
                return mappingRegistry.getMappingLookup().get(match);
            }
        }

        logger.debug("No matches found");
        return null;
    }
}
