package com.digiwin.dap.middle.ram.filter;

import com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandler;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.constant.InternalUrl;
import com.digiwin.dap.middleware.domain.FilterOrderEnum;
import org.springframework.core.Ordered;
import org.springframework.web.filter.OncePerRequestFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 应用授权检查管控
 *
 * @author fobgochod
 * @date 2022/4/11 16:48
 * @see com.digiwin.dap.middle.ram.service.authentication.AuthCheckHandlerComposite
 */
public class AuthCheckFilter extends OncePerRequestFilter implements Ordered {

    private final AuthCheckHandler authCheckHandler;

    public AuthCheckFilter(AuthCheckHandler authCheckHandler) {
        this.authCheckHandler = authCheckHandler;
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        // 登录和服务权限相关API，在Filter跳过检查，后续服务内部会检查
        if (InternalUrl.authAllows().get(request.getRequestURI()) == null) {
            final AppAuthContext context = AppAuthContextHolder.getContext();
            AuthResult authResult = authCheckHandler.processAuth(AuthResult.of(), context.getAuthoredUser(), context.getAuthoredSys(), context.getRequestInfo());
            AuthType.checkAuthResult(authResult.getAuthType(), context.getAuthoredUser(), context.getAuthoredSys());
        }
        filterChain.doFilter(request, response);
    }

    @Override
    public int getOrder() {
        return FilterOrderEnum.APP_CHECK.order();
    }
}
