package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.PolicyVO;
import com.digiwin.dap.middle.ram.domain.page.Filter;
import com.digiwin.dap.middle.ram.entity.Policy;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamPolicyMapper {

    int insert(@Param("entity") Policy entity);

    int deleteBySid(@Param("sid") long sid);

    int update(@Param("entity") Policy entity);

    Policy findBySid(@Param("sid") long sid);

    boolean exists(@Param("sid") long sid);

    long countByPage(@Param("cond") Policy cond, @Param("filter") Filter<?> filter);

    List<PolicyVO> findByPage(@Param("cond") Policy cond, @Param("filter") Filter<?> filter);

    List<Policy> findByCond(@Param("cond") Policy cond);

    Policy findByAppAndType(@Param("app") String app, @Param("policyType") String policyType);
}
